--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
-- Command Handler
-- HOUSELOGIX 2015
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////

COMMAND = {}

function ExecuteCommand(strCommand, tParams)
	trace('ExecuteCommand', strCommand)
	tParams = tParams or {}
	local strCmd = string.gsub(strCommand, " ","")
	if (strCommand == 'LUA_ACTION') then
		for cmd,cmdv in pairs(tParams) do
			if (cmd == 'ACTION') then
				if (COMMAND[cmdv] ~= nil and type(COMMAND[cmdv]) == 'function') then
					COMMAND[cmdv](tParams)
				else
					dbg('Unknown Action Command.')
				end
			end
		end
	else
		if (COMMAND[strCmd] ~= nil and type(COMMAND[strCmd]) == 'function') then
			COMMAND[strCmd](tParams)
		else
			dbg('Unknown command.')
		end
	end
end

--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
-- Debugging
-- HOUSELOGIX 2015
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////

function dbg(...)
	if (Properties['DEBUG MODE'] == 'ON') then print(...) end
end

function trace(strFn, ...)
	if (Properties['DEBUG MODE'] ~= 'ON') then return end
	for k,v in pairs(arg) do arg[k] = tostring(v) end
	dbg(string.format('[%s](%s)', strFn, table.concat(arg, ', ')))
end

function err(...)
	if (Properties['DEBUG MODE'] ~= 'ON') then return end
	for k,v in pairs(arg) do arg[k] = tostring(v) end
	dbg(string.format('[ERROR]: %s', table.concat(arg, ', ')))
end

--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--HOUSELOGIX EXCEPTION HANDLING ROUTINES
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////

function NilException(...)
    local throw = false
    local msg = ""
    for i=1,select("#",...) do
        local temp = select(i,...)
        if (temp) then
            if (i == 1) then
                temp = string.format("(%s): ", temp)
            elseif (type(temp) == "string") then
                temp = string.format("\"%s\"",temp)
            end
            msg = msg .. temp .. " "
        else
            msg = msg .. "NIL PARAM"
            throw = true
        end
    end
    if (throw) then msg = msg .. " -- THROWING AWAY" end
    dbg(msg)
    return throw
end

--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
-- Properties handler
-- HOUSELOGIX 2015
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////

PROPS = {}

function OnPropertyChanged(strProperty)
	trace('OnPropertyChanged', strProperty)
	local strProp = string.gsub(strProperty, ' ','')
	if (PROPS[strProp] ~= nil and type(PROPS[strProp]) == 'function') then
		PROPS[strProp](Properties[strProperty])
	end
end

--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
-- Lua table utils
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////

function PrintTable(tValue, sIndent)
	sIndent = sIndent or '   '
	for k,v in pairs(tValue) do
		print(sIndent .. tostring(k) .. ':  ' .. tostring(v))
		if (type(v) == 'table') then
			PrintTable(v, sIndent .. '   ')
		end
	end
end

function AlphabeticalPairs(t, f)
	local a = {}

	for n in pairs(t) do
		table.insert(a, n)
	end

	table.sort(a, f)

	local index = 0      -- iterator variable
	local iter = function ()   -- iterator function
			index = index + 1
			if a[index] == nil then
				return nil
			else
				return a[index], t[a[index]]
			end
		end

	return iter
end

-- Be aware, this is really a hack. You could get the wrong key for a value,
-- especially if your data has duplicate values.
function AlphabeticalPairsByValue(t, f)
	local a = {}

	for k,v in pairs(t) do
		table.insert(a, v)
	end

	table.sort(a, f)

	local index = 0
	local iter = function()
			index = index + 1
			if a[index] == nil then
				return nil
			else
				for k,v in pairs(t) do
					if v == a[index] then
						return k, v
					end
				end
			end
		end

	return iter
end

--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
-- Timer Helpers
-- HOUSELOGIX 2015
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////

if not HOUSELOGIX then HOUSELOGIX = {} end

function OnTimerExpired(idTimer)
	local timer = pullTimer(idTimer)
	if (not timer) then dbg("UNKNOWN TIMER FIRED | THROWING AWAY") return end
	timer.handler()
end

--------------------------------
-- Helpers
--------------------------------
g_timers = {}

function startTimer(value, units, callback)
	local timerId = C4:AddTimer(tonumber(value), units)
	g_timers[timerId] = { handler = callback }
	return timerId
end

function pullTimer(timerId)
	local timer = g_timers[timerId]
	g_timers[timerId] = nil
	return timer
end

function killTimer(timerId)
	local timer = g_timers[timerId]
	g_timers[timerId] = nil
	if tonumber(timerId) > 0 then
		C4:KillTimer(timerId)
	end
	return timer
end

--------------------------------
-- Classes
--------------------------------

--------------------------------
-- Resets self if started again before expiration
--------------------------------
function HOUSELOGIX.SingletonTimer(nInterval, strUnits, fnCallback)
	local self = {}

	local ID = 0
	local interval = nInterval
	local units = strUnits
	local callback = fnCallback

	function self.Start()
		if ID ~= 0 then
			killTimer(ID)
		end

		ID = startTimer(interval, units, callback)
	end

	function self.Stop()
		if ID ~= 0 then
			killTimer(ID)
			ID = 0
		end
	end

	return self
end

--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
-- URL Callbacks
-- HOUSELOGIX 2015
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////

g_responseTickets = {}

function ReceivedAsync(ticketId, strData, responseCode, tHeaders, strError)
	local ticket = pullUrlTicket(ticketId)
	if (not ticket) then dbg("[ReceivedAsync]: Unknown Ticket | Throwing Away") return end

	if (strError) then
		if (ticket.errorHandler and type(ticket.errorHandler) == 'function') then
			ticket.errorHandler(strError)
		else
			dbg("[ReceivedAsync]: ERROR | " .. strError)
		end

		return
	end

	if (strData) then
		if (ticket.handler and type(ticket.handler) == 'function') then
			ticket.handler(strData, tHeaders)
		else
			dbg("[ReceivedAsync]: #"..responseCode.."#" .. strData .. "#")
		end
	end
end

function urlGet(url, headers, callback, errorHandler)
	local ticketId = C4:urlGet(url, headers)
	g_responseTickets[ticketId] = { handler = callback, errorHandler = errorHandler }
end

function urlPost(url, data, headers, callback, errorHandler)
	local ticketId = C4:urlPost(url, data, headers)
	g_responseTickets[ticketId] = { handler = callback, errorHandler = errorHandler }
end

function urlPut(url, data, headers, callback, errorHandler)
	local ticketId = C4:urlPut(url, data, headers)
	g_responseTickets[ticketId] = { handler = callback, errorHandler = errorHandler }
end

function urlEncode(str)
	return str:gsub(" ","+"):gsub("\n","\r\n"):gsub("([^%w])",function(ch)
			return string.format("%%%02X",string.byte(ch))
		end)
end

function pullUrlTicket(ticketId)
	local ticket = g_responseTickets[ticketId]
	g_responseTickets[ticketId] = nil
	return ticket
end

function toboolean(val)
	local rval = false;

	if type(val) == "string" and (string.lower(val) == 'true' or val == "1") then
		rval = true
	elseif type(val) == "number" and val ~= 0 then
		rval =  true
	elseif type(val) == "boolean" then
		rval = val
	end

	return rval
end

function tointeger(val)
	local nval = tonumber(val)
	return (nval >= 0) and math.floor(nval + 0.5) or math.ceil(nval - 0.5)
end

function tonumber_loc(str, base)
    local s = str:gsub(",", ".") -- Assume US Locale decimal separator
    local num = tonumber(s, base)

    if (num == nil) then
        s = str:gsub("%.", ",") -- Non-US Locale decimal separator
        num = tonumber(s, base)
    end

    return num
end

function IsEmpty(str)
	return str == nil or str == ""
end

--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
-- HOUSELOGIX - LIFX Color Slider
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////

-- // CONSTANTS //
LIGHT_PROXY_BINDING = 5001
COLOR_CONTROL_BINDING = 2
gDimmerLevel = 0


-- // INIT //
function OnDriverInit()
	print('Initializing Driver')

  C4:SendToProxy(LIGHT_PROXY_BINDING, "ONLINE_CHANGED", { STATE = true })
end


PROXY_COMMANDS = {}

function ReceivedFromProxy(idBinding, strCommand, tParams)
  dbg("(ReceivedFromProxy) idBinding(" .. idBinding .. ") strCommand(" .. strCommand .. ")")
  tParams = tParams or {}

  if (PROXY_COMMANDS[strCommand] ~= nil and type(PROXY_COMMANDS[strCommand]) == 'function') then
    PROXY_COMMANDS[strCommand](tParams)
    else
        dbg('No Proxy Function found')
  end
end

function PROXY_COMMANDS.GET_CONNECTED_STATE(tParams)
	C4:SendToProxy(LIGHT_PROXY_BINDING, 'ONLINE_CHANGED', {STATE=true})
end

function PROXY_COMMANDS.GET_LIGHT_LEVEL(tParams)
	dbg("(PROXY): GET LIGHT LEVEL")
	C4:SendToProxy(LIGHT_PROXY_BINDING, "LIGHT_LEVEL", gDimmerLevel)
end

function PROXY_COMMANDS.LIGHT_LEVEL(tParams)
  dbg("(PROXY): LIGHT LEVEL changed to "..tParams.data)

  gDimmerLevel = tParams.data

  C4:SendToProxy(LIGHT_PROXY_BINDING, "LIGHT_LEVEL", gDimmerLevel)
end

function PROXY_COMMANDS.BUTTON_ACTION(tParams)
    local action = tParams["ACTION"]
    
    if (action == "2") then
        -- Click
        TOGGLE_PRESET(tParams)
    else
        dbg("UNKNOWN BTN ACTION | THROW AWAY: " .. tParams["ACTION"])
    end
end

function PROXY_COMMANDS.TOGGLE(tParams)
    TOGGLE_PRESET(tParams)
end

function TOGGLE_PRESET(tParams)
    if (tonumber(gDimmerLevel) == 0) then  -- this ignores presets and should be changed if presets are implemented -- turn on
        tParams["LEVEL"] = 100
        tParams["TIME"] = gClickRampRateUp
    else -- turn off
        tParams["LEVEL"] = 0
        tParams["TIME"] = gClickRampRateDown
    end
    PROXY_COMMANDS.SET_LEVEL(tParams)
end

function PROXY_COMMANDS.SET_LEVEL(tParams)

    -- SET COLOR_LEVEL TO THE NEW LEVEL
    gDimmerLevel = tParams.LEVEL

    -- SEND HUE TO LIGHT(S)
    C4:SendToProxy(COLOR_CONTROL_BINDING, "SET_COLOR_LEVEL", {LEVEL = tParams.LEVEL})
    C4:SendToProxy(LIGHT_PROXY_BINDING, "LIGHT_LEVEL", tParams.LEVEL)
end

function PROXY_COMMANDS.RAMP_TO_LEVEL(tParams)

	-- SET COLOR_LEVEL TO THE NEW LEVEL
    gDimmerLevel = tParams.LEVEL

    -- SEND HUE TO LIGHT(S)
    C4:SendToProxy(COLOR_CONTROL_BINDING, "SET_COLOR_LEVEL", {LEVEL = tParams.LEVEL, TIME = tParams.TIME})
    C4:SendToProxy(LIGHT_PROXY_BINDING, "LIGHT_LEVEL", tParams.LEVEL)
end

--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
-- ADVANCED LIGHTING SCENES
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////

sceneCollection     = PersistData["sceneCollection"] or {}
flashCollection     = PersistData["flashCollection"] or {}
elementCounter      = 0
currentScene        = 0
executeElementTimer = 0

function PROXY_COMMANDS.PUSH_SCENE(tParams)
    for k,v in pairs(tParams) do
        dbg(k .. ": " .. v)
    end
    local sceneNum = tParams["SCENE_ID"]
    local elements = tParams["ELEMENTS"]
    local flash = tParams["FLASH"]
    dbg("scene_id: " .. sceneNum)
    dbg("elements: " .. tParams["ELEMENTS"])
	dbg("flash: " .. tParams["FLASH"])
    local elementTable = collect(elements)
    local scene = {}
    for i=1,#elementTable do
        local t = {}
        t["Delay"] = elementTable[i][1][1]
        t["Rate"] = elementTable[i][2][1]
        t["Level"] = elementTable[i][3][1]
        table.insert(scene,t)
    end
    sceneCollection[sceneNum] = scene
    flashCollection[sceneNum] = flash
    PersistData["sceneCollection"] = sceneCollection
    PersistData["flashCollection"] = flashCollection
end

function PROXY_COMMANDS.REMOVE_SCENE(tParams)
    local sceneNum = tParams["SCENE_ID"]
    dbg("scene_id: " .. sceneNum)
    sceneCollection[sceneNum] = nil
    flashCollection[sceneNum] = nil
    PersistData["sceneCollection"] = sceneCollection
    PersistData["flashCollection"] = flashCollection
end

function PROXY_COMMANDS.ACTIVATE_SCENE(tParams)
    local sceneNum = tParams["SCENE_ID"]
    for k,v in pairs(tParams) do
        dbg(k .. ": " .. v)
    end
    currentScene = sceneNum
    elementCounter = 0
    playScene()
end

function playScene()
    dbg("playScene")
    if (elementCounter ~= 0) then
        local t = {}
        t["LEVEL"] = sceneCollection[tostring(currentScene)][elementCounter]["Level"] -- Given range 0-100
        t["TIME"] = sceneCollection[tostring(currentScene)][elementCounter]["Rate"]

        print("T.LEVEL: " .. t["LEVEL"] .. " T.TIME: " .. t["TIME"])
		
		PROXY_COMMANDS.RAMP_TO_LEVEL({LEVEL = tonumber(t["LEVEL"]), TIME = tonumber(t["TIME"])})
    end
    elementCounter = elementCounter + 1
    dbg("elementCounter is now " .. elementCounter)

    if (elementCounter > #sceneCollection[tostring(currentScene)] and flashCollection[tostring(currentScene)] == "1") then
        elementCounter = 1
    end

    if (elementCounter <= #sceneCollection[tostring(currentScene)]) then
        local timeInterval = sceneCollection[tostring(currentScene)][elementCounter]["Delay"] or -1
        executeElementTimer = killTimer(executeElementTimer)
        executeElementTimer = startTimer(timeInterval, "MILLISECONDS", playScene )
    else
        dbg("end of scene")
    end

end

--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
-- ADVANCED LIGHTING SCENES HELPER FUNCTIONS
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////

function parseargs(s)
  local arg = {}
  string.gsub(s, "(%w+)=([\"'])(.-)%2", function (w, _, a)
    arg[w] = a
  end)
  return arg
end


function collect(s)
  local stack = {}
  local top = {}
  table.insert(stack, top)
  local ni,c,label,xarg, empty
  local i, j = 1, 1
  while true do
    ni,j,c,label,xarg, empty = string.find(s, "<(%/?)([%w:]+)(.-)(%/?)>", i)
    if not ni then break end
    local text = string.sub(s, i, ni-1)
    if not string.find(text, "^%s*$") then
      table.insert(top, text)
    end
    if empty == "/" then  -- empty element tag
      table.insert(top, {label=label, xarg=parseargs(xarg), empty=1})
    elseif c == "" then   -- start tag
      top = {label=label, xarg=parseargs(xarg)}
      table.insert(stack, top)   -- new level
    else  -- end tag
      local toclose = table.remove(stack)  -- remove top
      top = stack[#stack]
      if #stack < 1 then
        error("nothing to close with "..label)
      end
      if toclose.label ~= label then
        error("trying to close "..toclose.label.." with "..label)
      end
      table.insert(top, toclose)
    end
    i = j+1
  end
  local text = string.sub(s, i)
  if not string.find(text, "^%s*$") then
    table.insert(stack[#stack], text)
  end
  if #stack > 1 then
    error("unclosed "..stack[#stack].label)
  end
  return stack[1]
end

--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////
--//////////--//////////--//////////--//////////--//////////--//////////--//////////

function ReceivedFromNetwork(idBinding, nPort, strData)
	dbg('RX: ' .. idBinding .. ' ' .. nPort .. ' ' .. strData)

end

